org 100h   ; assume ax=bx=0 si=0x100 di=sp=-2

  mov al,0x13

;Palette: green + purple
;bx=index dh=R ch=G cl=B
P int 0x10     ; init: set 320x200 mode
  neg bl
  xchg dh,ch
  neg si
  js P
  shrd cx,bx,9
  mov ax,0x1010; set palette index
  dec bx
  jnz P        ; bx=0

  fninit

;be 28 = 10430 ~ 65536/2pi
K mov si,0x4028; si=0x4028: sin->cos phase (should be 0x4000)
  mov ds,si    ; ds=0x4028: table segment

  push 0xa000 - 160/16
  mov bp,sp    ; bp=-4

;Sine table
S mov [bp+si],bx
  fild word[bp+si]  ;| t
  fidiv word[bp+4+K];| T=t/65536*2pi
  fsin              ;| sinT
  fstp dword[bx]
  sub bx,sp    ; +4
  jnz S

  pop es       ; es=0x9ff6: centered screen segment

M:

;For each pixel: find dX,dY,dZ and initialize X,Y,Z
;bx=time di=pixel_address si=0x4028
X mov ax,0xcccd
  mov cl,124   ; cl=dZ=0x7c??
  mul di
  sub dh,cl    ; dh=dY (centered), dl=dX bx=T=time
  pusha        ; -9 -8 -7 -6 -5 -4 -3
               ; bh dl dh cl ch al ah
               ; ( dX )
               ;    ( dY )
               ;       ( dZ )

  mov ax,si    ; ax=X=0x4028
  cwd          ; dx=Y=0
Z:

;Compute the distance to the gyroid
G fld dword[bx+si]
  xchg ax,dx   ;| cosZ | cosY | cosX
  xchg ax,bx   ; ax=X dx=Y bx=Z -> ax=Z dx=X bx=Y
  fmul dword[bx]
  inc bp       ;| cosZ*sinY | cosY*sinX | cosX*sinZ
  jpo G        ; bp=-1
  faddp
  faddp        ;| d=cosZ*sinY+cosY*sinX+cosX*sinZ
  fist word[bp-3]; store trunc(d) (+1 or -1) to [-4] (pushed ax)
  fabs         ;| |d|
  fldl2e       ;| offset=1.442695 |d|
  fsubrp st1,st0;| D=offset-|d|

;Advance ray
A:
;  fild word[bp-6]   ;| dZ D
;  fmul st1          ;| dZ*D D
;  fistp dword[bp+si]
;  xchg ax,dx
;  xchg ax,bx   ; ax=X dx=Y bx=Z -> ax=Z dx=X bx=Y
;  sar dword[bp+si],3  ; distance factor: 0.25
;  adc ax,[bp+si]; Y+=dY*D/4 | X+=dX*D/4 | Z+=dZ*D/4
;  and al,0xfc  ; align to a multiple of 4 (for sintable)
;  dec bp
;  jpo A        ; si=0x100

  mov di,[bp-6]
  sar di,4
  xchg ax,dx
  xchg ax,bx   ; ax=X dx=Y bx=Z -> ax=Z dx=X bx=Y
  add ax,di    ; Y+=dY*D/4 | X+=dX*D/4 | Z+=dZ*D/4
  and al,0xfc  ; align to a multiple of 4 (for sintable)
  dec bp
  jpo A        ; si=0x100

;Close enough?
  fstp dword[bp+si]
  cmp byte[bp+si+3],0x3e
  jl D         ; hit if D<0.125 (= bits(D)<0x3e000000)

  dec cx
  loop Z       ; max 63 iterations
;  add cx,bp
;  jnz Z

;Draw pixel
D xor [bp],cl  ; add number of iters to [-4] (pushed ax)
;  inc di       ; set zero flag
  popa
  stosb        ; al=color
  test di,di
  jnz X

;Next frame
  add bh,4     ; time++
;  inc bh       ; time++

  jmp M
;  in al,0x60   ; esc check
;  dec ax
;  jnz M
;  ret

;c65536div2pi: dw 10430 ; 65536/2pi
;cDistFactor: dd 0.25   ; (0.75 (Lipchitz constant) / 44700 (avg dir length)) * 65536/2pi
;cOffset: dd 1.5

;; Palette test
;  push 0xa000
;  pop es
;  xor di,di
;  xor ax,ax
;Y stosb
;  inc al
;  jnz Y
;  add di,64
;  jns Y
;
;  xor ax,ax
;  int 0x16
;  ret
